import Layout from '@/layout/index.vue'
import type { RouteRecordRaw } from 'vue-router'

const routes: Array<RouteRecordRaw> = [
  {
    path: '/:channel',
    name: 'Home',
    meta: { title: '好医生保险经纪' },
    component: () => import('@/views/home/index.vue')
  },
  {
    path: '/result',
    name: 'Result',
    meta: { title: '好医生保险经纪' },
    component: () => import('@/views/result/index.vue')
  },
  {
    path: '/tab',
    name: 'tab',
    component: Layout,
    redirect: { name: 'Tab' },
    children: [
      {
        path: 'tab',
        name: 'Tab',
        component: () => import('@/views/tab/index.vue'),
        meta: { title: 'TAB页面' }
      }
    ]
  }
]

export default routes
